/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Direction;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraftforge.client.ForgeRenderTypes;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelTransformComposition;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class MultiLayerModel
implements IModelGeometry<MultiLayerModel> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ImmutableList<Pair<RenderType, IUnbakedModel>> models;
    private final boolean convertRenderTypes;

    public MultiLayerModel(Map<RenderType, IUnbakedModel> models) {
        this((ImmutableList<Pair<RenderType, IUnbakedModel>>)((ImmutableList)models.entrySet().stream().map(kv -> Pair.of(kv.getKey(), kv.getValue())).collect(ImmutableList.toImmutableList())), true);
    }

    public MultiLayerModel(ImmutableList<Pair<RenderType, IUnbakedModel>> models, boolean convertRenderTypes) {
        this.models = models;
        this.convertRenderTypes = convertRenderTypes;
    }

    @Override
    public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet materials = Sets.newHashSet();
        materials.add(owner.resolveTexture("particle"));
        for (Pair m : this.models) {
            materials.addAll(((IUnbakedModel)m.getSecond()).func_225614_a_(modelGetter, missingTextureErrors));
        }
        return materials;
    }

    private static ImmutableList<Pair<RenderType, IBakedModel>> buildModels(List<Pair<RenderType, IUnbakedModel>> models, IModelTransform modelTransform, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, ResourceLocation modelLocation) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Pair<RenderType, IUnbakedModel> entry : models) {
            builder.add((Object)Pair.of((Object)entry.getFirst(), (Object)((IUnbakedModel)entry.getSecond()).func_225613_a_(bakery, spriteGetter, modelTransform, modelLocation)));
        }
        return builder.build();
    }

    @Override
    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
        return new MultiLayerBakedModel(owner.useSmoothLighting(), owner.isShadedInGui(), owner.isSideLit(), spriteGetter.apply(owner.resolveTexture("particle")), overrides, this.convertRenderTypes, (List<Pair<RenderType, IBakedModel>>)MultiLayerModel.buildModels(this.models, modelTransform, bakery, spriteGetter, modelLocation), PerspectiveMapWrapper.getTransforms(new ModelTransformComposition(owner.getCombinedTransform(), modelTransform)));
    }

    public static final class Loader
    implements IModelLoader<MultiLayerModel> {
        public static final ImmutableBiMap<String, RenderType> BLOCK_LAYERS = ImmutableBiMap.builder().put((Object)"solid", (Object)RenderType.func_228639_c_()).put((Object)"cutout", (Object)RenderType.func_228643_e_()).put((Object)"cutout_mipped", (Object)RenderType.func_228641_d_()).put((Object)"translucent", (Object)RenderType.func_228645_f_()).put((Object)"tripwire", (Object)RenderType.func_241715_r_()).build();
        public static final Loader INSTANCE = new Loader();

        private Loader() {
        }

        @Override
        public void func_195410_a(IResourceManager resourceManager) {
        }

        @Override
        public MultiLayerModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            ImmutableList.Builder builder = ImmutableList.builder();
            JsonObject layersObject = JSONUtils.func_152754_s((JsonObject)modelContents, (String)"layers");
            for (Map.Entry layer : BLOCK_LAYERS.entrySet()) {
                String layerName = (String)layer.getKey();
                if (!layersObject.has(layerName)) continue;
                builder.add((Object)Pair.of(layer.getValue(), (Object)deserializationContext.deserialize((JsonElement)JSONUtils.func_152754_s((JsonObject)layersObject, (String)layerName), BlockModel.class)));
            }
            boolean convertRenderTypes = JSONUtils.func_151209_a((JsonObject)modelContents, (String)"convert_render_types", (boolean)true);
            return new MultiLayerModel((ImmutableList<Pair<RenderType, IUnbakedModel>>)builder.build(), convertRenderTypes);
        }
    }

    private static final class MultiLayerBakedModel
    implements IDynamicBakedModel {
        private final ImmutableMap<RenderType, IBakedModel> models;
        private final ImmutableMap<ItemCameraTransforms.TransformType, TransformationMatrix> cameraTransforms;
        protected final boolean ambientOcclusion;
        protected final boolean gui3d;
        protected final boolean isSideLit;
        protected final TextureAtlasSprite particle;
        protected final ItemOverrideList overrides;
        private final List<BakedQuad> missing = ImmutableList.of();
        private final boolean convertRenderTypes;
        private final List<Pair<IBakedModel, RenderType>> itemLayers;
        public static BiMap<RenderType, RenderType> ITEM_RENDER_TYPE_MAPPING = HashBiMap.create();

        public MultiLayerBakedModel(boolean ambientOcclusion, boolean isGui3d, boolean isSideLit, TextureAtlasSprite particle, ItemOverrideList overrides, boolean convertRenderTypes, List<Pair<RenderType, IBakedModel>> models, ImmutableMap<ItemCameraTransforms.TransformType, TransformationMatrix> cameraTransforms) {
            this.isSideLit = isSideLit;
            this.cameraTransforms = cameraTransforms;
            this.ambientOcclusion = ambientOcclusion;
            this.gui3d = isGui3d;
            this.particle = particle;
            this.overrides = overrides;
            this.convertRenderTypes = convertRenderTypes;
            this.models = ImmutableMap.copyOf(models.stream().collect(Collectors.toMap(Pair::getFirst, Pair::getSecond)));
            this.itemLayers = models.stream().map(kv -> {
                RenderType rt = (RenderType)kv.getFirst();
                if (convertRenderTypes) {
                    rt = (RenderType)ITEM_RENDER_TYPE_MAPPING.getOrDefault((Object)rt, (Object)rt);
                }
                return Pair.of((Object)kv.getSecond(), (Object)rt);
            }).collect(Collectors.toList());
        }

        @Override
        @Nonnull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
            RenderType layer = MinecraftForgeClient.getRenderLayer();
            if (layer == null) {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (IBakedModel model : this.models.values()) {
                    builder.addAll((Iterable)model.getQuads(state, side, rand, extraData));
                }
                return builder.build();
            }
            if (state == null && this.convertRenderTypes) {
                layer = (RenderType)ITEM_RENDER_TYPE_MAPPING.inverse().getOrDefault((Object)layer, (Object)layer);
            }
            if (this.models.containsKey((Object)layer)) {
                return ((IBakedModel)this.models.get((Object)layer)).getQuads(state, side, rand, extraData);
            }
            return this.missing;
        }

        public boolean func_177555_b() {
            return this.ambientOcclusion;
        }

        public boolean isAmbientOcclusion(BlockState state) {
            return this.ambientOcclusion;
        }

        public boolean func_177556_c() {
            return this.gui3d;
        }

        public boolean func_230044_c_() {
            return this.isSideLit;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.particle;
        }

        public boolean doesHandlePerspectives() {
            return true;
        }

        public IBakedModel handlePerspective(ItemCameraTransforms.TransformType cameraTransformType, MatrixStack mat) {
            return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.cameraTransforms, cameraTransformType, mat);
        }

        public ItemOverrideList func_188617_f() {
            return ItemOverrideList.field_188022_a;
        }

        public boolean isLayered() {
            return true;
        }

        public List<Pair<IBakedModel, RenderType>> getLayerModels(ItemStack itemStack, boolean fabulous) {
            return this.itemLayers;
        }

        static {
            ITEM_RENDER_TYPE_MAPPING.put((Object)RenderType.func_228639_c_(), (Object)ForgeRenderTypes.ITEM_LAYERED_SOLID.get());
            ITEM_RENDER_TYPE_MAPPING.put((Object)RenderType.func_228643_e_(), (Object)ForgeRenderTypes.ITEM_LAYERED_CUTOUT.get());
            ITEM_RENDER_TYPE_MAPPING.put((Object)RenderType.func_228641_d_(), (Object)ForgeRenderTypes.ITEM_LAYERED_CUTOUT_MIPPED.get());
            ITEM_RENDER_TYPE_MAPPING.put((Object)RenderType.func_228645_f_(), (Object)ForgeRenderTypes.ITEM_LAYERED_TRANSLUCENT.get());
        }
    }
}

